// /dashboard/assets/js/users.js
(() => {
  const API = '/dashboard/api/';
  const tbody = document.getElementById('usersTbody');
  const noUsers = document.getElementById('noUsers');
  const modalRoot = document.getElementById('modalRoot');
  const openAdd = document.getElementById('openAdd');

  function roleHtml(r){
    if (r === 'admin') return '<span class="role-pill role-admin">ADMIN</span>';
    return '<span class="role-pill role-editor">EDITOR</span>';
  }
  function escapeHtml(s){ if (!s) return ''; return String(s).replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

  function createRow(u){
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td><img class="avatar" src="${u.photo_url || '/dashboard/assets/images/user-placeholder.png'}" alt="avatar"></td>
      <td>${escapeHtml(u.name || u.username || '')}</td>
      <td>${escapeHtml(u.email || '')}</td>
      <td>${roleHtml(u.role)}</td>
      <td>${u.status == 1 ? '<span class="small-muted">Active</span>' : '<span class="small-muted">Disabled</span>'}</td>
      <td>
        <button class="btn ghost" data-id="${u.id}" data-action="edit">Edit</button>
        <button class="btn" data-id="${u.id}" data-action="delete" style="background:#c0392b">Delete</button>
      </td>`;
    return tr;
  }

  async function loadUsers(){
    tbody.innerHTML = '';
    noUsers.style.display = 'none';
    try {
      const res = await fetch(API + 'get_users.php', {cache:'no-store'});
      const json = await res.json();
      if (!json.ok || !Array.isArray(json.data) || json.data.length === 0) { noUsers.style.display = 'block'; return; }
      json.data.forEach(u => tbody.appendChild(createRow(u)));
    } catch (e) { console.error(e); noUsers.style.display = 'block'; }
  }

  openAdd.addEventListener('click', ()=> openModal());

  tbody.addEventListener('click', (ev)=>{
    const btn = ev.target.closest('button'); if (!btn) return;
    const id = btn.dataset.id; const action = btn.dataset.action;
    if (action === 'edit') editUser(id);
    if (action === 'delete') deleteUser(id);
  });

  async function editUser(id){
    try {
      const res = await fetch(API + 'get_users.php');
      const json = await res.json();
      const user = (json.data||[]).find(x => String(x.id) === String(id));
      openModal(user);
    } catch (e) { console.error(e); alert('Unable to load user data'); }
  }

  function openModal(user = null){
    modalRoot.style.display = 'block';
    modalRoot.innerHTML = `
      <div class="modal-backdrop" id="modalBackdrop">
        <div class="modal" role="dialog">
          <h3>${user ? 'Edit User' : 'Add User'}</h3>
          <div class="small-muted" style="margin-bottom:10px">${user ? 'Update the user details. Leave password blank to keep unchanged.' : 'Create a new user account.'}</div>
          <div style="margin-bottom:8px" class="card">
            <div class="form-grid">
              <div><label>Username</label><input id="m_username" class="input" value="${escapeHtml(user?.username||'')}" /></div>
              <div><label>Email</label><input id="m_email" class="input" value="${escapeHtml(user?.email||'')}" /></div>
              <div class="full"><label>Full name</label><input id="m_name" class="input" value="${escapeHtml(user?.name||'')}" /></div>
              <div><label>Role</label><select id="m_role" class="select"><option value="editor">Editor</option><option value="admin">Admin</option></select></div>
              <div><label>Status</label><select id="m_status" class="select"><option value="1">Active</option><option value="0">Disabled</option></select></div>
              <div class="full"><label>Password <small class="small-muted">(leave empty to keep)</small></label><input id="m_password" type="password" class="input" /></div>
            </div>
          </div>

          <div style="display:flex;gap:8px;justify-content:flex-end;margin-top:10px">
            <button id="m_cancel" class="btn ghost">Close</button>
            <button id="m_save" class="btn">${user ? 'Save' : 'Create'}</button>
          </div>
        </div>
      </div>
    `;

    if (user){ document.getElementById('m_role').value = user.role||'editor'; document.getElementById('m_status').value = user.status==1 ? '1' : '0'; }

    document.getElementById('m_cancel').addEventListener('click', closeModal);
    document.getElementById('modalBackdrop').addEventListener('click', (e)=> { if (e.target.id === 'modalBackdrop') closeModal(); });
    document.getElementById('m_save').addEventListener('click', async ()=>{
      const payload = {
        id: user ? user.id : 0,
        username: document.getElementById('m_username').value.trim(),
        name: document.getElementById('m_name').value.trim(),
        email: document.getElementById('m_email').value.trim(),
        role: document.getElementById('m_role').value,
        status: document.getElementById('m_status').value,
        password: document.getElementById('m_password').value
      };
      if (!payload.username || !payload.email) { alert('Username and email are required'); return; }
      try {
        const fd = new FormData();
        Object.keys(payload).forEach(k => fd.append(k, payload[k]));
        const res = await fetch(API + 'save_user.php', { method:'POST', body: fd, credentials:'same-origin' });
        const json = await res.json();
        if (!res.ok || !json.ok) { alert(json.error || 'Save failed'); return; }
        closeModal(); await loadUsers();
      } catch (e) { console.error(e); alert('Network error'); }
    });
  }

  function closeModal(){ modalRoot.style.display = 'none'; modalRoot.innerHTML = ''; }

  async function deleteUser(id){
    if (!confirm('Delete this user?')) return;
    try {
      const fd = new FormData(); fd.append('id', id);
      const res = await fetch(API + 'delete_user.php', { method:'POST', body: fd, credentials:'same-origin' });
      const json = await res.json();
      if (!res.ok || !json.ok) { alert(json.error || 'Delete failed'); return; }
      await loadUsers();
    } catch (e) { console.error(e); alert('Network error'); }
  }

  // start
  loadUsers();
})();
