const API_U = "/dashboard/api/";
const fileInput = document.getElementById("fileInput");
const fileTitle = document.getElementById("fileTitle");
const uploadBtn = document.getElementById("uploadBtn");
const clearBtn = document.getElementById("clearBtn");
const refreshBtn = document.getElementById("refreshUploadsBtn");
const uploadsList = document.getElementById("uploadsList");
const noUploads = document.getElementById("noUploads");

uploadBtn.onclick = async ()=>{
  const f = fileInput.files[0];
  if(!f) return alert("Choose a file");
  uploadBtn.disabled = true; uploadBtn.textContent = "Uploading...";
  const form = new FormData(); form.append("file", f); if(fileTitle.value.trim()) form.append("title", fileTitle.value.trim());
  const res = await fetch(API_U + "upload_file.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  uploadBtn.disabled = false; uploadBtn.textContent = "Upload";
  if(res && res.status==="success"){ fileInput.value=""; fileTitle.value=""; loadUploads(); } else alert("Upload failed");
};

clearBtn.onclick = ()=> { fileInput.value=""; fileTitle.value=""; };
refreshBtn && refreshBtn.addEventListener("click", loadUploads);

async function loadUploads(){
  uploadsList.innerHTML=""; noUploads.style.display="none";
  const res = await fetch(API_U + "get_uploads.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noUploads.style.display="block"; return; }
  res.data.forEach(u=>{
    const tr=document.createElement("tr");
    tr.innerHTML = `<td><a href="${u.url}" target="_blank">${escapeHtml(u.name)}</a></td><td>${escapeHtml(u.size||u.filesize||"")}</td><td>${escapeHtml(u.date||u.uploaded_at||"")}</td>
      <td><button class="btn-ghost" onclick="downloadUpload(${u.id})">Download</button><button class="btn" style="background:#c0392b;margin-left:6px;" onclick="deleteUpload(${u.id})">Delete</button></td>`;
    uploadsList.appendChild(tr);
  });
}

window.downloadUpload = async (id)=>{
  const res = await fetch(API_U + "get_uploads.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data)) return alert("Not found");
  const item = res.data.find(x=>x.id==id);
  if(item && item.url) window.open(item.url, "_blank"); else alert("File not found");
};

window.deleteUpload = async (id)=>{
  if(!confirm("Delete?")) return;
  const form = new FormData(); form.append("id", id);
  const res = await fetch(API_U + "delete_upload.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success") loadUploads(); else alert("Delete failed");
};

function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

document.addEventListener("DOMContentLoaded", loadUploads);
