/* /dashboard/assets/js/theme.js
   Global delegated theme handler — recommended approach.
   - Applies saved theme on page load
   - Delegated click listener works even if topbar is injected later
   - Minimal, safe, and reusable across all pages
*/
(function(){
  const KEY = 'bb_theme';

  // Apply saved theme immediately
  try {
    if (localStorage.getItem(KEY) === 'light') {
      document.documentElement.dataset.theme = 'light';
    } else {
      document.documentElement.removeAttribute('data-theme');
    }
  } catch(e){ console.warn('theme load error', e); }

  // Toggle logic
  function toggleTheme() {
    const isLight = document.documentElement.dataset.theme === 'light';
    if (isLight) {
      document.documentElement.removeAttribute('data-theme');
      try { localStorage.removeItem(KEY); } catch(e){}
    } else {
      document.documentElement.dataset.theme = 'light';
      try { localStorage.setItem(KEY, 'light'); } catch(e){}
    }
  }

  // Delegated click — works even when topbar is loaded via fetch()
  document.addEventListener('click', function(ev){
    const btn = ev.target.closest && ev.target.closest('#toggleThemeBtn');
    if (!btn) return;
    ev.preventDefault();
    toggleTheme();
  }, false);

  // Optional: expose for console testing
  window.BBTheme = {
    toggle: toggleTheme,
    apply: function(){ try { if (localStorage.getItem(KEY) === 'light') document.documentElement.dataset.theme = 'light'; else document.documentElement.removeAttribute('data-theme'); } catch(e){} }
  };
})();
