const API_S = "/dashboard/api/";
const seasonList = document.getElementById("seasonList");
const noSeasons = document.getElementById("noSeasons");
const addSeasonBtn = document.getElementById("addSeasonBtn");
const seasonModal = document.getElementById("seasonModal");
const closeSeasonModal = document.getElementById("closeSeasonModal");
const saveSeasonBtn = document.getElementById("saveSeasonBtn");

const s_number = document.getElementById("s_number");
const s_ultimate = document.getElementById("s_ultimate");
const s_language = document.getElementById("s_language");
const s_host = document.getElementById("s_host");
const s_year = document.getElementById("s_year");
const s_desc = document.getElementById("s_desc");
const s_trophy = document.getElementById("s_trophy");

let editSeasonId = null;

addSeasonBtn.onclick = ()=> openModal();
closeSeasonModal.onclick = ()=> closeModal();
seasonModal.onclick = (e)=> { if(e.target === seasonModal) closeModal(); };

function openModal(id=null, data=null){
  editSeasonId = id;
  seasonModal.classList.add("open");
  if(data){
    s_number.value = data.season_no || "";
    s_ultimate.value = data.ultimate_no || "";
    s_year.value = data.year || "";
    s_desc.value = data.description || "";
    setSelect(s_language, data.language_id);
    setSelect(s_host, data.host_id);
  } else {
    s_number.value=""; s_ultimate.value=""; s_year.value=""; s_desc.value=""; s_trophy.value="";
  }
}

function closeModal(){ seasonModal.classList.remove("open"); editSeasonId=null; }

async function loadLookups(){
  s_language.innerHTML = '<option value="">Select language</option>';
  const langs = await fetch(API_S + "get_languages.php").then(r=>r.json()).catch(()=>null);
  if(langs && Array.isArray(langs.data)) langs.data.forEach(l=> { const o=document.createElement("option"); o.value=l.id; o.textContent=l.name; s_language.appendChild(o); });

  s_host.innerHTML = '<option value="">Select host</option>';
  const hosts = await fetch(API_S + "get_hosts.php").then(r=>r.json()).catch(()=>null);
  if(hosts && Array.isArray(hosts.data)) hosts.data.forEach(h=> { const o=document.createElement("option"); o.value=h.id; o.textContent=h.name; s_host.appendChild(o); });
}

async function loadSeasons(){
  seasonList.innerHTML=""; noSeasons.style.display="none";
  const res = await fetch(API_S + "get_seasons.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noSeasons.style.display="block"; return; }
  res.data.forEach(s=>{
    const tr=document.createElement("tr");
    tr.innerHTML = `<td>${escapeHtml(s.season_no||"-")}</td><td>${escapeHtml(s.language_name||"-")}</td><td>${escapeHtml(s.host_name||"-")}</td><td>${escapeHtml(s.year||"-")}</td>
    <td><button class="btn-ghost" onclick="editSeason(${s.id})">Edit</button><button class="btn" style="background:#c0392b;margin-left:6px;" onclick="deleteSeason(${s.id})">Delete</button></td>`;
    seasonList.appendChild(tr);
  });
}

window.editSeason = async (id)=>{
  const res = await fetch(API_S + "get_season.php?id="+id).then(r=>r.json()).catch(()=>null);
  if(res && res.data) openModal(id,res.data);
};
window.deleteSeason = async (id)=>{ if(!confirm("Delete?")) return; const form=new FormData(); form.append("id",id); const res = await fetch(API_S + "delete_season.php", {method:"POST", body: form}).then(r=>r.json()).catch(()=>null); if(res && res.status==="success") loadSeasons(); else alert("Delete failed"); };

saveSeasonBtn.onclick = async ()=>{
  const form = new FormData();
  form.append("season_no", s_number.value.trim());
  form.append("ultimate_no", s_ultimate.value.trim());
  form.append("language_id", s_language.value);
  form.append("host_id", s_host.value);
  form.append("year", s_year.value.trim());
  form.append("description", s_desc.value.trim());
  if(editSeasonId) form.append("id", editSeasonId);
  if(s_trophy.files[0]) form.append("trophy", s_trophy.files[0]);
  const res = await fetch(API_S + "save_season.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success"){ closeModal(); loadSeasons(); } else alert("Save failed");
};

function setSelect(sel, val){ [...sel.options].forEach(o=>o.selected = (o.value == val)); }
function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

document.addEventListener("DOMContentLoaded", ()=>{ loadLookups(); loadSeasons(); });
