const API_P = "/dashboard/api/";
const profileList = document.getElementById("profileList");
const noProfiles = document.getElementById("noProfiles");
const addProfileBtn = document.getElementById("addProfileBtn");
const profileModal = document.getElementById("profileModal");
const closeProfileModal = document.getElementById("closeProfileModal");
const saveProfileBtn = document.getElementById("saveProfileBtn");
const p_name = document.getElementById("p_name");
const p_season = document.getElementById("p_season");
const p_language = document.getElementById("p_language");
const p_bio = document.getElementById("p_bio");
const p_photo = document.getElementById("p_photo");
let editProfileId = null;

addProfileBtn.onclick = ()=> openModal();
closeProfileModal.onclick = ()=> closeModal();
profileModal.onclick = (e)=> { if(e.target === profileModal) closeModal(); };

function openModal(id=null, data=null){
  editProfileId = id;
  profileModal.classList.add("open");
  if(data){ p_name.value=data.name||""; p_bio.value=data.bio||""; setSelect(p_season,data.season_id); setSelect(p_language,data.language_id); } else { p_name.value=""; p_bio.value=""; p_photo.value=""; }
}
function closeModal(){ profileModal.classList.remove("open"); editProfileId=null; }

async function loadLookups(){
  p_season.innerHTML='<option value="">Select season</option>';
  const seasons = await fetch(API_P + "get_seasons.php").then(r=>r.json()).catch(()=>null);
  if(seasons && Array.isArray(seasons.data)) seasons.data.forEach(s=>{ const o=document.createElement("option"); o.value=s.id; o.textContent=s.title||s.season_no||s.name; p_season.appendChild(o); });
  p_language.innerHTML='<option value="">Select language</option>';
  const langs = await fetch(API_P + "get_languages.php").then(r=>r.json()).catch(()=>null);
  if(langs && Array.isArray(langs.data)) langs.data.forEach(l=>{ const o=document.createElement("option"); o.value=l.id; o.textContent=l.name; p_language.appendChild(o); });
}

async function loadProfiles(){
  profileList.innerHTML=""; noProfiles.style.display="none";
  const res = await fetch(API_P + "get_profiles.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noProfiles.style.display="block"; return; }
  res.data.forEach(p=>{
    const tr=document.createElement("tr");
    tr.innerHTML = `<td>${p.photo_url?`<img src="${p.photo_url}" style="width:100px;height:70px;object-fit:cover;border-radius:6px;">`:'<div style="width:100px;height:70px;display:flex;align-items:center;color:var(--text-muted)">No Photo</div>'}</td>
      <td>${escapeHtml(p.name)}</td><td>${escapeHtml(p.season_name||"")}</td><td>${escapeHtml(p.language_name||"")}</td>
      <td><button class="btn-ghost" onclick="editProfile(${p.id})">Edit</button><button class="btn" style="background:#c0392b;margin-left:6px;" onclick="deleteProfile(${p.id})">Delete</button></td>`;
    profileList.appendChild(tr);
  });
}

window.editProfile = async (id)=>{ const res = await fetch(API_P + "get_profile.php?id="+id).then(r=>r.json()).catch(()=>null); if(res && res.data) openModal(id,res.data); };
window.deleteProfile = async (id)=>{ if(!confirm("Delete?")) return; const f=new FormData(); f.append("id",id); const res = await fetch(API_P + "delete_profile.php", {method:"POST", body:f}).then(r=>r.json()).catch(()=>null); if(res && res.status==="success") loadProfiles(); else alert("Failed"); };

saveProfileBtn.onclick = async ()=>{
  const name = p_name.value.trim(); if(!name) return alert("Name required");
  const form=new FormData(); form.append("name",name); form.append("season_id",p_season.value); form.append("language_id",p_language.value); form.append("bio",p_bio.value);
  if(editProfileId) form.append("id", editProfileId); if(p_photo.files[0]) form.append("photo", p_photo.files[0]);
  const res = await fetch(API_P + "save_profile.php", {method:"POST", body: form}).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success"){ closeModal(); loadProfiles(); } else alert("Save failed");
};

function setSelect(sel, val){ [...sel.options].forEach(o=>o.selected = (o.value == val)); }
function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

document.addEventListener("DOMContentLoaded", ()=>{ loadLookups(); loadProfiles(); });
