const API = "/dashboard/api/login.php";
const msg = document.getElementById("loginMsg");

document.getElementById("togglePwd").onclick = () => {
  const p = document.getElementById("password");
  p.type = p.type === "password" ? "text" : "password";
  togglePwd.textContent = p.type === "password" ? "Show" : "Hide";
};

document.getElementById("loginBtn").onclick = async () => {
  msg.textContent = "";

  const fd = new FormData();
  fd.append("username", document.getElementById("username").value.trim());
  fd.append("password", document.getElementById("password").value);
  fd.append("remember", document.getElementById("remember").checked ? "1" : "0");

  try {
    const res = await fetch(API, { method: "POST", body: fd });
    const json = await res.json();

    if (json.ok) {
      window.location.href = "/dashboard/index.html";
    } else {
      msg.textContent = json.error || "Login failed";
    }
  } catch (e) {
    msg.textContent = "Network error";
  }
};
