// loadLayout.js - injects sidebar & topbar and then fires a custom event "layout:ready"
document.addEventListener("DOMContentLoaded", () => {
  const base = "/dashboard";
  const load = async (path) => {
    try {
      const r = await fetch(path, {cache: "no-store"});
      if(!r.ok) throw new Error(path + " -> " + r.status);
      return await r.text();
    } catch (err) {
      console.error("loadLayout error:", err);
      return null;
    }
  };

  (async function(){
    const sidebarHtml = await load(base + "/sidebar.html");
    if(sidebarHtml){
      const ds = document.createElement("div");
      ds.innerHTML = sidebarHtml;
      // Insert as first child so layout positions correctly
      document.body.insertBefore(ds.firstElementChild, document.body.firstChild);
    }

    const topbarHtml = await load(base + "/topbar.html");
    if(topbarHtml){
      const dt = document.createElement("div");
      dt.innerHTML = topbarHtml;
      // insert topbar before content (so topbar is above .content)
      document.body.insertBefore(dt.firstElementChild, document.querySelector(".content"));
    }

    // ensure theme initial state (light) applied
    try {
      if(localStorage.getItem("bb_theme") === "light") document.documentElement.dataset.theme = "light";
      else document.documentElement.removeAttribute("data-theme");
    } catch(e){ /* ignore */ }

    // dispatch event so other scripts can safely attach handlers
    window.dispatchEvent(new CustomEvent("layout:ready"));
  })();
});
