const LANG_API = "/dashboard/api/";
const languageList = document.getElementById("languageList");
const noLangs = document.getElementById("noLangs");
const addLangBtn = document.getElementById("addLangBtn");
const langModal = document.getElementById("langModal");
const closeLangModal = document.getElementById("closeLangModal");
const saveLangBtn = document.getElementById("saveLangBtn");
const l_name = document.getElementById("l_name");
let editLangId = null;

addLangBtn.onclick = ()=> openLangModal();
closeLangModal.onclick = ()=> closeLangModalFn();
langModal.onclick = (e)=> { if(e.target === langModal) closeLangModalFn(); };

function openLangModal(id=null, name=""){
  editLangId = id;
  langModal.classList.add("open");
  l_name.value = name || "";
  document.getElementById("langModalTitle").textContent = id ? "Edit Language" : "Add Language";
}
function closeLangModalFn(){ langModal.classList.remove("open"); editLangId=null; l_name.value=""; }

async function loadLanguages(){
  languageList.innerHTML = "";
  noLangs.style.display = "none";
  const res = await fetch(LANG_API + "get_languages.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noLangs.style.display="block"; return; }
  res.data.forEach(lang=>{
    const tr = document.createElement("tr");
    tr.innerHTML = `<td>${escapeHtml(lang.name)}</td>
      <td>
        <button class="btn-ghost" onclick="openLangModal(${lang.id}, '${escapeJs(lang.name)}')">Edit</button>
        <button class="btn btn-ghost" onclick="deleteLang(${lang.id})" style="background:#c0392b;color:#fff;border-radius:8px;">Delete</button>
      </td>`;
    languageList.appendChild(tr);
  });
}

saveLangBtn.onclick = async ()=>{
  const name = l_name.value.trim();
  if(!name) return alert("Enter a name");
  const form = new FormData(); form.append("name", name);
  if(editLangId) form.append("id", editLangId);
  const res = await fetch(LANG_API + "save_language.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success"){ closeLangModalFn(); loadLanguages(); } else alert("Save failed");
};

async function deleteLang(id){
  if(!confirm("Delete?")) return;
  const form = new FormData(); form.append("id", id);
  const res = await fetch(LANG_API + "delete_language.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success") loadLanguages(); else alert("Delete failed");
}

function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g, c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }
function escapeJs(s){ return (s||"").replace(/'/g,"\\'").replace(/\n/g,"\\n"); }

document.addEventListener("DOMContentLoaded", loadLanguages);
