/* index.js - ready to paste */
const API_BASE = "/dashboard/api/";

/* Safe fetch JSON */
async function fetchJson(url){
  try {
    const r = await fetch(url, {cache:"no-store"});
    if (!r.ok) return null;
    return await r.json();
  } catch (e) {
    console.error("fetch error", e);
    return null;
  }
}

/* load stats */
async function loadStats(){
  try{
    const langs = await fetchJson(API_BASE + "get_languages.php");
    const hosts = await fetchJson(API_BASE + "get_hosts.php");
    const conts = await fetchJson(API_BASE + "get_contestants.php");
    const seas = await fetchJson(API_BASE + "get_seasons.php");

    document.getElementById("statLanguages").textContent = (langs?.data?.length) || 0;
    document.getElementById("statHosts").textContent = (hosts?.data?.length) || 0;
    document.getElementById("statContestants").textContent = (conts?.data?.length) || 0;
    document.getElementById("statSeasons").textContent = (seas?.data?.length) || 0;

    // recent activity (example uses get_recent_contestants.php if exists)
    const recentEl = document.getElementById("recentActivity");
    if (recentEl) {
      const recent = await fetchJson(API_BASE + "get_recent_contestants.php");
      recentEl.innerHTML = "";
      if (!recent?.data?.length) {
        recentEl.innerHTML = `<tr><td colspan="2" style="text-align:center;color:var(--text-muted)">No recent activity</td></tr>`;
      } else {
        recent.data.forEach(r => {
          recentEl.innerHTML += `<tr><td>${r.action||r.name||'Activity'}</td><td>${r.created_at||r.date||'–'}</td></tr>`;
        });
      }
    }
  } catch(e){ console.error(e); }
}

/* UI handlers */
function attachHandlers() {
  const sidebar = document.querySelector(".sidebar");
  const sidebarToggle = document.getElementById("sidebarToggle");
  const content = document.querySelector(".content");

  if (sidebarToggle && sidebar && content) {
    sidebarToggle.addEventListener("click", () => {
      sidebar.classList.toggle("collapsed");
      if (sidebar.classList.contains("collapsed")) content.style.marginLeft = "64px";
      else content.style.marginLeft = "240px";
      sidebarToggle.style.display = "block";
    });
  }

  // theme toggle
  const themeBtn = document.getElementById("toggleThemeBtn");
  if (themeBtn) {
    themeBtn.onclick = () => {
      if (document.documentElement.dataset.theme === "light") {
        document.documentElement.removeAttribute("data-theme");
        localStorage.removeItem("bb_theme");
      } else {
        document.documentElement.dataset.theme = "light";
        localStorage.setItem("bb_theme","light");
      }
    };
  }

  // notifications & profile dropdown toggles
  document.addEventListener('click', (e) => {
    const notifBtn = document.getElementById('notifBtn');
    const notifDropdown = document.getElementById('notifDropdown');
    const profileBtn = document.getElementById('profileBtn');
    const profileDropdown = document.getElementById('profileDropdown');

    if (notifBtn && notifDropdown) {
      if (notifBtn.contains(e.target)) {
        notifDropdown.style.display = notifDropdown.style.display === 'block' ? 'none' : 'block';
        profileDropdown && (profileDropdown.style.display = 'none');
      } else if (notifDropdown && !notifDropdown.contains(e.target)) {
        notifDropdown.style.display = 'none';
      }
    }

    if (profileBtn && profileDropdown) {
      if (profileBtn.contains(e.target)) {
        profileDropdown.style.display = profileDropdown.style.display === 'block' ? 'none' : 'block';
        notifDropdown && (notifDropdown.style.display = 'none');
      } else if (profileDropdown && !profileDropdown.contains(e.target)) {
        profileDropdown.style.display = 'none';
      }
    }
  });

  // refresh recent
  const refreshBtns = document.querySelectorAll('#refreshRecent, #refreshActivity');
  refreshBtns.forEach(b => b && b.addEventListener('click', loadStats));
}

/* init */
window.addEventListener('load', () => {
  // apply saved theme
  if (localStorage.getItem("bb_theme") === "light") document.documentElement.dataset.theme = "light";
  attachHandlers();
  loadStats();
});
