const API_BASE = "/dashboard/api/";
const contestantList = document.getElementById("contestantList");
const noContestants = document.getElementById("noContestants");
const addContestantBtn = document.getElementById("addContestantBtn");
const contestModal = document.getElementById("contestModal");
const closeContestModal = document.getElementById("closeContestModal");
const saveContestBtn = document.getElementById("saveContestBtn");
const ct_name = document.getElementById("ct_name");
const ct_language = document.getElementById("ct_language");
const ct_season = document.getElementById("ct_season");
const ct_bio = document.getElementById("ct_bio");
const ct_photo = document.getElementById("ct_photo");
let editContestId = null;

addContestantBtn.onclick = ()=> openModal();
closeContestModal.onclick = ()=> closeModal();
contestModal.onclick = (e)=> { if(e.target === contestModal) closeModal(); };

function openModal(id=null, data=null){
  editContestId = id;
  contestModal.classList.add("open");
  if(data){
    ct_name.value = data.name || "";
    ct_bio.value = data.bio || "";
    setSelect(ct_language, data.language_id);
    setSelect(ct_season, data.season_id);
  } else {
    ct_name.value = ""; ct_bio.value = ""; ct_photo.value = "";
  }
}

function closeModal(){ contestModal.classList.remove("open"); editContestId = null; }

async function fillSelects(){
  // languages
  ct_language.innerHTML = '<option value="">Select language</option>';
  const langs = await fetch(API_BASE + "get_languages.php").then(r=>r.json()).catch(()=>null);
  if(langs && Array.isArray(langs.data)) langs.data.forEach(l=> { const o=document.createElement("option"); o.value=l.id; o.textContent=l.name; ct_language.appendChild(o); });

  // seasons
  ct_season.innerHTML = '<option value="">Select season</option>';
  const seasons = await fetch(API_BASE + "get_seasons.php").then(r=>r.json()).catch(()=>null);
  if(seasons && Array.isArray(seasons.data)) seasons.data.forEach(s=>{ const o=document.createElement("option"); o.value=s.id; o.textContent=s.title||s.season_no||s.name; ct_season.appendChild(o); });
}

async function loadContestants(){
  contestantList.innerHTML=""; noContestants.style.display="none";
  const res = await fetch(API_BASE + "get_contestants.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noContestants.style.display="block"; return; }
  res.data.forEach(c=>{
    const tr=document.createElement("tr");
    tr.innerHTML = `<td>${c.photo_url? `<img src="${c.photo_url}" style="width:100px;height:60px;object-fit:cover;border-radius:6px;">` : '<div style="width:100px;height:60px;display:flex;align-items:center;color:var(--text-muted)">No photo</div>'}</td>
      <td>${escapeHtml(c.name)}</td><td>${escapeHtml(c.language_name||"")}</td><td>${escapeHtml(c.season_name||"")}</td>
      <td><button class="btn-ghost" onclick="editContest(${c.id})">Edit</button><button class="btn" style="background:#c0392b;margin-left:6px;" onclick="deleteContest(${c.id})">Delete</button></td>`;
    contestantList.appendChild(tr);
  });
}

window.editContest = async (id)=>{
  const res = await fetch(API_BASE + "get_contestant.php?id="+id).then(r=>r.json()).catch(()=>null);
  if(res && res.data) openModal(id,res.data);
};
window.deleteContest = async (id)=>{
  if(!confirm("Delete?")) return;
  const form = new FormData(); form.append("id", id);
  const res = await fetch(API_BASE + "delete_contestant.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success") loadContestants(); else alert("Failed");
};

saveContestBtn.onclick = async ()=>{
  const name = ct_name.value.trim();
  if(!name) return alert("Name required");
  const form = new FormData();
  form.append("name", name);
  form.append("language_id", ct_language.value);
  form.append("season_id", ct_season.value);
  form.append("bio", ct_bio.value);
  if(editContestId) form.append("id", editContestId);
  if(ct_photo.files[0]) form.append("photo", ct_photo.files[0]);
  const res = await fetch(API_BASE + "save_contestant.php", { method:"POST", body: form }).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success"){ closeModal(); loadContestants(); } else alert("Save failed");
};

function setSelect(sel, val){
  [...sel.options].forEach(o=> o.selected = (o.value == val));
}
function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g, c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

document.addEventListener("DOMContentLoaded", ()=>{ fillSelects(); loadContestants(); });
