const API_B = "/dashboard/api/";
const broadcastList = document.getElementById("broadcastList");
const noBroadcasts = document.getElementById("noBroadcasts");
const addBroadcastBtn = document.getElementById("addBroadcastBtn");
const broadcastModal = document.getElementById("broadcastModal");
const closeBroadcastModal = document.getElementById("closeBroadcastModal");
const saveBroadcastBtn = document.getElementById("saveBroadcastBtn");
const b_name = document.getElementById("b_name");
const b_language = document.getElementById("b_language");
const b_type = document.getElementById("b_type");
const b_link = document.getElementById("b_link");
const b_logo = document.getElementById("b_logo");
let editBroadcastId = null;

addBroadcastBtn.onclick = ()=> openModal();
closeBroadcastModal.onclick = ()=> closeModal();
broadcastModal.onclick = (e)=> { if(e.target === broadcastModal) closeModal(); };

function openModal(id=null, data=null){
  editBroadcastId = id; broadcastModal.classList.add("open");
  if(data){ b_name.value=data.name||""; b_type.value=data.type||"ott"; b_link.value=data.link||""; setSelect(b_language, data.language_id); } else { b_name.value=""; b_type.value="ott"; b_link.value=""; b_logo.value=""; }
}
function closeModal(){ broadcastModal.classList.remove("open"); editBroadcastId=null; }

async function loadLangs(){ b_language.innerHTML='<option value="">Select language</option>'; const res = await fetch(API_B + "get_languages.php").then(r=>r.json()).catch(()=>null); if(res && Array.isArray(res.data)) res.data.forEach(l=>{ const o=document.createElement("option"); o.value=l.id; o.textContent=l.name; b_language.appendChild(o); }); }

async function loadBroadcasts(){
  broadcastList.innerHTML=""; noBroadcasts.style.display="none";
  const res = await fetch(API_B + "get_broadcasts.php").then(r=>r.json()).catch(()=>null);
  if(!res || !Array.isArray(res.data) || res.data.length===0){ noBroadcasts.style.display="block"; return; }
  res.data.forEach(b=>{
    const card=document.createElement("div"); card.className="card"; card.style.width="260px";
    card.innerHTML = `<div style="display:flex;gap:8px;align-items:center;">
      <div style="width:70px;height:50px;border-radius:6px;overflow:hidden;background:#0e1113;border:1px solid var(--border-subtle);">${b.logo_url?`<img src="${b.logo_url}" style="width:100%;height:100%;object-fit:cover;">`:"<div style='color:var(--text-muted);padding:8px;'>No logo</div>"}</div>
      <div><strong>${escapeHtml(b.name)}</strong><div style="font-size:12px;color:var(--text-muted)">${b.language_name||""} • ${b.type||""}</div></div></div>
      <div style="display:flex;justify-content:flex-end;margin-top:10px;gap:8px;"><button class="btn-ghost" onclick="editBroadcast(${b.id})">Edit</button><button class="btn" style="background:#c0392b;" onclick="deleteBroadcast(${b.id})">Delete</button></div>`;
    broadcastList.appendChild(card);
  });
}

window.editBroadcast = async (id)=>{ const res = await fetch(API_B + "get_broadcast.php?id="+id).then(r=>r.json()).catch(()=>null); if(res && res.data) openModal(id,res.data); };
window.deleteBroadcast = async (id)=>{ if(!confirm("Delete?")) return; const f=new FormData(); f.append("id",id); const res = await fetch(API_B + "delete_broadcast.php", {method:"POST", body:f}).then(r=>r.json()).catch(()=>null); if(res && res.status==="success") loadBroadcasts(); else alert("Failed"); };

saveBroadcastBtn.onclick = async ()=>{
  const name = b_name.value.trim(); if(!name) return alert("Name required");
  const form = new FormData(); form.append("name",name); form.append("language_id",b_language.value); form.append("type",b_type.value); form.append("link",b_link.value);
  if(editBroadcastId) form.append("id", editBroadcastId); if(b_logo.files[0]) form.append("logo", b_logo.files[0]);
  const res = await fetch(API_B + "save_broadcast.php", {method:"POST", body: form}).then(r=>r.json()).catch(()=>null);
  if(res && res.status==="success"){ closeModal(); loadBroadcasts(); } else alert("Save failed");
};

function setSelect(sel,val){ [...sel.options].forEach(o=>o.selected = (o.value == val)); }
function escapeHtml(s){ if(!s) return ""; return String(s).replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'}[c])); }

document.addEventListener("DOMContentLoaded", ()=>{ loadLangs(); loadBroadcasts(); });
