<?php
header('Content-Type: application/json');
$uploaddir = __DIR__ . '/../uploads/';
if(!is_dir($uploaddir)) mkdir($uploaddir, 0755, true);

if(empty($_FILES['file'])) {
    echo json_encode(['status'=>'error','message'=>'No file uploaded']); exit;
}

$f = $_FILES['file'];
$ext = pathinfo($f['name'], PATHINFO_EXTENSION);
$fname = 'img_' . time() . '_' . bin2hex(random_bytes(4)) . '.' . $ext;
$target = $uploaddir . $fname;

if(move_uploaded_file($f['tmp_name'], $target)){
    // adjust public path if necessary
    $public = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['REQUEST_URI']) . '/../uploads/' . $fname;
    echo json_encode(['status'=>'success', 'url' => $public]);
    exit;
} else {
    echo json_encode(['status'=>'error','message'=>'Upload failed']);
    exit;
}
?>
