<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if(!isset($data['id'])){
        echo json_encode(["status"=>"error","message"=>"ID missing"]);
        exit;
    }

    $social = json_encode($data['social'] ?? []);
    $gallery = json_encode($data['gallery'] ?? []);

    $stmt = $conn->prepare("
        UPDATE profiles SET
          name = :name,
          language = :language,
          age = :age,
          photo = :photo,
          description = :description,
          social = :social,
          gallery = :gallery
        WHERE id = :id
    ");

    $stmt->execute([
        ":id" => $data['id'],
        ":name" => $data['name'] ?? "",
        ":language" => $data['language'] ?? "",
        ":age" => $data['age'] ?? "",
        ":photo" => $data['photo'] ?? "",
        ":description" => $data['description'] ?? "",
        ":social" => $social,
        ":gallery" => $gallery
    ]);

    echo json_encode(["status"=>"success","message"=>"Profile updated"]);
}
catch(Exception $e){
    echo json_encode(["status"=>"error", "message"=>$e->getMessage()]);
}
?>
