<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);
    if(!$input || !isset($input['id'])) throw new Exception("Invalid input");

    $id = $input['id'];
    $name = $input['name'] ?? '';
    $language = $input['language'] ?? '';
    $bio = $input['bio'] ?? '';
    $working_years = $input['working_years'] ?? '';
    $photo = $input['photo'] ?? '';

    if(!$name) throw new Exception("Name is required");

    $stmt = $conn->prepare("UPDATE hosts SET name = :name, language = :language, bio = :bio, working_years = :working_years, photo = :photo WHERE id = :id");
    $stmt->execute([
        ":name" => $name,
        ":language" => $language,
        ":bio" => $bio,
        ":working_years" => $working_years,
        ":photo" => $photo,
        ":id" => $id
    ]);

    echo json_encode(["status"=>"success"]);
    exit;
} catch(Exception $e){
    echo json_encode(["status"=>"error", "message"=>$e->getMessage()]);
    exit;
}
?>
