<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data['id'])) {
        echo json_encode(["status"=>"error", "message"=>"ID missing"]);
        exit;
    }

    $social = json_encode($data['social'] ?? []);

    $stmt = $conn->prepare("
        UPDATE contestants SET
        name = :name,
        language = :language,
        show_type = :show_type,
        season_no = :season_no,
        photo = :photo,
        description = :description,
        social = :social
        WHERE id = :id
    ");

    $stmt->execute([
        ":id"          => $data["id"],
        ":name"        => $data["name"],
        ":language"    => $data["language"],
        ":show_type"   => $data["show_type"],
        ":season_no"   => $data["season_no"],
        ":photo"       => $data["photo"],
        ":description" => $data["description"],
        ":social"      => $social
    ]);

    echo json_encode(["status"=>"success","message"=>"Contestant updated"]);

} catch (Exception $e) {
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
?>
