<?php
require_once "db.php";
session_start();

$id       = $_POST['id'] ?? 0;
$name     = trim($_POST['name'] ?? "");
$email    = trim($_POST['email'] ?? "");
$role     = $_POST['role'] ?? "editor";
$status   = $_POST['status'] ?? 1;
$password = $_POST['password'] ?? "";

if ($name === "" || $email === "") {
    echo json_encode(["ok"=>false,"error"=>"Missing fields"]);
    exit;
}

$photo_url = null;
if (!empty($_FILES['photo']['name'])) {
    $fn = time()."_".basename($_FILES['photo']['name']);
    $path = __DIR__."/../uploads/".$fn;
    move_uploaded_file($_FILES['photo']['tmp_name'], $path);
    $photo_url = "/dashboard/uploads/".$fn;
}

if ($id == 0) {
    // new user
    $hash = $password ? password_hash($password, PASSWORD_DEFAULT) : "";

    $sql = "INSERT INTO users (name,email,role,status,password_hash,photo_url,created_at)
            VALUES (:n,:e,:r,:s,:p,:ph,NOW())";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        "n"=>$name,
        "e"=>$email,
        "r"=>$role,
        "s"=>$status,
        "p"=>$hash,
        "ph"=>$photo_url
    ]);

    echo json_encode(["ok"=>true]);
    exit;
}

// update existing
$set = "name=:n,email=:e,role=:r,status=:s";
$data = ["n"=>$name,"e"=>$email,"r"=>$role,"s"=>$status,"id"=>$id];

if ($password !== "") {
    $set .= ", password_hash=:p";
    $data["p"] = password_hash($password,PASSWORD_DEFAULT);
}

if ($photo_url !== null) {
    $set .= ", photo_url=:ph";
    $data["ph"] = $photo_url;
}

$sql = "UPDATE users SET $set WHERE id=:id";
$stmt = $pdo->prepare($sql);
$stmt->execute($data);

echo json_encode(["ok"=>true]);
