<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);

    if (!$input) {
        echo json_encode(["status" => "error", "message" => "No input received"]);
        exit;
    }

    // Convert arrays to JSON
    $participants = json_encode($input["participants"] ?? []);
    $placements   = json_encode($input["placements"] ?? []);
    $broadcasts   = json_encode($input["broadcasts"] ?? []);
    $house_photos = json_encode($input["house_photos"] ?? []);

    // Insert season
    $stmt = $conn->prepare("
        INSERT INTO seasons 
        (season_number, language, tag, show_type, show_type_label, year, description, host_id,
         participants, placements, broadcasts, logo, trophy, house_photos)
        VALUES 
        (:season_number, :language, :tag, :show_type, :show_type_label, :year, :description, :host_id,
         :participants, :placements, :broadcasts, :logo, :trophy, :house_photos)
    ");

    $stmt->execute([
        ":season_number"    => $input["season_number"] ?? null,
        ":language"         => $input["language"] ?? "",
        ":tag"              => $input["tag"] ?? "",
        ":show_type"        => $input["show_type"] ?? "",
        ":show_type_label"  => $input["show_type_label"] ?? "",
        ":year"             => $input["year"] ?? "",
        ":description"      => $input["description"] ?? "",
        ":host_id"          => $input["host_id"] ?? null,
        ":participants"     => $participants,
        ":placements"       => $placements,
        ":broadcasts"       => $broadcasts,
        ":logo"             => $input["logo"] ?? "",
        ":trophy"           => $input["trophy_photo"] ?? "",
        ":house_photos"     => $house_photos
    ]);

    echo json_encode([
        "status" => "success",
        "message" => "Season added successfully"
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
?>
