<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if(!$data){
        echo json_encode(["status"=>"error","message"=>"No input"]);
        exit;
    }

    $social = json_encode($data['social'] ?? []);
    $gallery = json_encode($data['gallery'] ?? []);

    $stmt = $conn->prepare("
        INSERT INTO profiles
        (name, language, age, photo, description, social, gallery)
        VALUES 
        (:name, :language, :age, :photo, :description, :social, :gallery)
    ");

    $stmt->execute([
        ":name" => $data['name'] ?? "",
        ":language" => $data['language'] ?? "",
        ":age" => $data['age'] ?? "",
        ":photo" => $data['photo'] ?? "",
        ":description" => $data['description'] ?? "",
        ":social" => $social,
        ":gallery" => $gallery
    ]);

    echo json_encode(["status"=>"success", "message"=>"Profile added"]);
}
catch(Exception $e){
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
?>
