<?php
// save_host.php
header('Content-Type: application/json; charset=utf-8');

try {
    require_once __DIR__ . '/db.php';
    // Optional: require_once __DIR__ . '/check_auth.php';

    // Basic input
    $name = trim($_POST['name'] ?? '');
    $language_id = (int)($_POST['language_id'] ?? 0);
    $bio = trim($_POST['bio'] ?? '');

    if ($name === '') {
        http_response_code(400);
        echo json_encode(['ok'=>false, 'error'=>'Name required']);
        exit;
    }

    // Upload handling
    $uploadDir = __DIR__ . '/../uploads/hosts/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0755, true);
    }

    $photoFileName = null;
    if (!empty($_FILES['photo']) && $_FILES['photo']['error'] === UPLOAD_ERR_OK) {
        $f = $_FILES['photo'];
        // validate mime/type & size (e.g. limit 4MB)
        $allowed = ['image/jpeg','image/png','image/webp'];
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime = finfo_file($finfo, $f['tmp_name']);
        finfo_close($finfo);

        if (!in_array($mime, $allowed)) {
            http_response_code(400);
            echo json_encode(['ok'=>false, 'error'=>'Invalid image type']);
            exit;
        }
        if ($f['size'] > 5 * 1024 * 1024) {
            http_response_code(400);
            echo json_encode(['ok'=>false, 'error'=>'Image too large (max 5MB)']);
            exit;
        }

        $ext = pathinfo($f['name'], PATHINFO_EXTENSION);
        $photoFileName = time() . '_' . bin2hex(random_bytes(6)) . '.' . $ext;
        $target = $uploadDir . $photoFileName;
        if (!move_uploaded_file($f['tmp_name'], $target)) {
            http_response_code(500);
            echo json_encode(['ok'=>false, 'error'=>'Failed to move uploaded file']);
            exit;
        }
        // Optionally create thumbnail here
    }

    // Insert into DB
    $sql = "INSERT INTO hosts (name, language_id, bio, photo, created_at) VALUES (:name, :lang, :bio, :photo, NOW())";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':name'=>$name,
        ':lang'=> $language_id ?: null,
        ':bio'=>$bio,
        ':photo'=>$photoFileName
    ]);

    echo json_encode(['ok'=>true, 'id' => $pdo->lastInsertId()]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
