<?php
// reset_admin_password.php  -- run once, then delete this file
ini_set('display_errors',1);
error_reporting(E_ALL);

require_once __DIR__.'/db.php'; // ensure this path is correct

$userToReset = 'admin';      // username to reset
$new_password = 'admin123';  // new password (change before running!)

try {
    if (!($pdo instanceof PDO)) throw new Exception('$pdo not ready');
    $hash = password_hash($new_password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("UPDATE users SET password_hash = :h WHERE username = :u");
    $stmt->execute(['h'=>$hash, 'u'=>$userToReset]);
    echo "OK: password reset for user {$userToReset}\n";
} catch (Exception $e) {
    http_response_code(500);
    echo "ERROR: " . $e->getMessage();
}
