<?php
// /dashboard/api/logout.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/db.php';
session_start();

$userId = $_SESSION['user_id'] ?? null;
if ($userId) {
    try {
        $stmt = $pdo->prepare("UPDATE users SET remember_token_hash = NULL WHERE id = :id");
        $stmt->execute(['id' => $userId]);
    } catch (PDOException $e) {
        // ignore
    }
}

// clear session and cookie
session_unset();
session_destroy();
setcookie('bb_rem', '', time() - 3600, '/', '', isset($_SERVER['HTTPS']), true);

// If called from browser, redirect to login. If called via fetch, return JSON.
if (php_sapi_name() !== 'cli') {
    header('Location: /dashboard/login.html');
    exit;
}
echo json_encode(['ok' => true]);
exit;
