<?php
// /dashboard/api/login.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/db.php';
session_start();

try {
  if (!($pdo instanceof PDO)) throw new Exception('$pdo not ready');
  $username = trim($_POST['username'] ?? '');
  $password = $_POST['password'] ?? '';
  $remember = isset($_POST['remember']) && ($_POST['remember'] == '1' || $_POST['remember'] == 'on');

  if ($username === '' || $password === '') {
    http_response_code(400);
    echo json_encode(['error'=>'Missing credentials']);
    exit;
  }

  // Query by username only (your users table does not have an email column)
  $stmt = $pdo->prepare("SELECT * FROM users WHERE username = :u LIMIT 1");
  $stmt->execute(['u'=>$username]);
  $user = $stmt->fetch(PDO::FETCH_ASSOC);

  if (!$user || !password_verify($password, $user['password_hash'])) {
    http_response_code(401);
    echo json_encode(['error'=>'Invalid credentials']);
    exit;
  }

  // Success
  $_SESSION['user_id'] = (int)$user['id'];
  $_SESSION['role'] = $user['role'] ?? 'editor';

  // update last_login
  $upd = $pdo->prepare("UPDATE users SET last_login = NOW() WHERE id = :id");
  $upd->execute(['id'=>$user['id']]);

  if ($remember) {
    $token = bin2hex(random_bytes(32));
    $tokenHash = password_hash($token, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("UPDATE users SET remember_token_hash = :h WHERE id = :id");
    $stmt->execute(['h'=>$tokenHash, 'id'=>$user['id']]);

    // cookie: 30 days, HttpOnly, Secure if HTTPS
    setcookie('bb_rem', $token, time() + (30*24*60*60), '/', '', isset($_SERVER['HTTPS']), true);
  }

  echo json_encode(['ok'=>true, 'role'=>$user['role'] ?? 'editor']);
} catch (PDOException $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
} catch (Exception $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
