<?php
// get_hosts.php
header('Content-Type: application/json; charset=utf-8');
try {
    require_once __DIR__ . '/db.php';
    // Optional: require_once __DIR__ . '/check_auth.php';

    $sql = "SELECT h.id, h.name, h.bio, h.photo, l.name AS language
            FROM hosts h
            LEFT JOIN languages l ON l.id = h.language_id
            ORDER BY h.name ASC";
    $stmt = $pdo->query($sql);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // convert photo filename => accessible URL (relative)
    $base = '/dashboard/uploads/hosts/';
    foreach ($rows as &$r) {
        $r['photo_url'] = ($r['photo'] && file_exists(__DIR__ . '/../uploads/hosts/' . $r['photo'])) 
            ? $base . $r['photo'] 
            : '/dashboard/assets/images/placeholder-host.png';
    }

    echo json_encode(['ok'=>true, 'data'=>$rows]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
