<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);

    if (!isset($input["id"])) {
        echo json_encode(["status" => "error", "message" => "Season ID missing"]);
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM seasons WHERE id = :id");
    $stmt->execute([":id" => $input["id"]]);

    echo json_encode([
        "status" => "success",
        "message" => "Season deleted"
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
?>
