<?php
// delete_host.php
header('Content-Type: application/json; charset=utf-8');

try {
    require_once __DIR__ . '/db.php';
    // Optional: require_once __DIR__ . '/check_auth.php';

    $id = (int)($_POST['id'] ?? 0);
    if (!$id) {
        http_response_code(400);
        echo json_encode(['ok'=>false, 'error'=>'Missing ID']);
        exit;
    }

    // get photo name first
    $stmt = $pdo->prepare("SELECT photo FROM hosts WHERE id=:id LIMIT 1");
    $stmt->execute([':id'=>$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($row && $row['photo']) {
        $file = __DIR__ . '/../uploads/hosts/' . $row['photo'];
        if (file_exists($file)) @unlink($file);
    }

    $del = $pdo->prepare("DELETE FROM hosts WHERE id=:id LIMIT 1");
    $del->execute([':id'=>$id]);

    echo json_encode(['ok'=>true]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
