<?php
// /dashboard/api/debug_db.php
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__.'/db.php';

try {
    // Get list of columns for `users`
    $stmt = $pdo->prepare("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = :db AND TABLE_NAME = 'users'");
    $stmt->execute(['db' => $pdo->query('select database()')->fetchColumn()]);
    $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Fetch some rows (limit to 20)
    $rows = [];
    $q = $pdo->query("SELECT * FROM users LIMIT 20");
    $rows = $q->fetchAll();

    echo json_encode([
        'ok' => true,
        'columns' => $cols,
        'row_count' => count($rows),
        'rows' => $rows
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => $e->getMessage(),
        'file' => $e->getFile(),
        'line' => $e->getLine()
    ]);
    exit;
}
