// login.js (paste to /dashboard/js/login.js)
(() => {
  const id = s => document.getElementById(s);
  const username = id('username');
  const password = id('password');
  const remember = id('remember');
  const loginBtn = id('loginBtn');
  const errorBox = id('error');

  function showError(msg){
    errorBox.style.display = 'block';
    errorBox.textContent = msg;
  }
  function hideError(){ errorBox.style.display='none'; errorBox.textContent=''; }

  async function doLogin(){
    hideError();
    const u = username.value.trim();
    const p = password.value;
    if(!u || !p) return showError('Enter username and password');

    loginBtn.disabled = true;
    try {
      const resp = await fetch('/dashboard/api/login.php', {
        method: 'POST',
        headers: {'Content-Type':'application/json'},
        body: JSON.stringify({ username: u, password: p, remember: !!remember.checked })
      });
      const j = await resp.json();
      if(j.status === 'success'){
        // redirect to dashboard home
        window.location.href = '/dashboard/index.html';
      } else {
        showError(j.message || 'Login failed');
      }
    } catch(e){
      showError('Network error');
      console.error(e);
    } finally {
      loginBtn.disabled = false;
    }
  }

  loginBtn.addEventListener('click', doLogin);
  document.addEventListener('keydown', (e) => { if(e.key === 'Enter') doLogin(); });

  // optional: prefill from localStorage if remember used
  try {
    const saved = localStorage.getItem('bb_admin_user');
    if(saved) username.value = saved;
  } catch(e){}
})();
