<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);

    if (!$input || !isset($input["id"])) {
        echo json_encode(["status" => "error", "message" => "Missing season ID"]);
        exit;
    }

    $participants = json_encode($input["participants"] ?? []);
    $placements   = json_encode($input["placements"] ?? []);
    $broadcasts   = json_encode($input["broadcasts"] ?? []);
    $house_photos = json_encode($input["house_photos"] ?? []);

    $stmt = $conn->prepare("
        UPDATE seasons SET
            season_number = :season_number,
            language = :language,
            tag = :tag,
            show_type = :show_type,
            show_type_label = :show_type_label,
            year = :year,
            description = :description,
            host_id = :host_id,
            participants = :participants,
            placements = :placements,
            broadcasts = :broadcasts,
            logo = :logo,
            trophy = :trophy,
            house_photos = :house_photos
        WHERE id = :id
    ");

    $stmt->execute([
        ":season_number"   => $input["season_number"] ?? null,
        ":language"        => $input["language"] ?? "",
        ":tag"             => $input["tag"] ?? "",
        ":show_type"       => $input["show_type"] ?? "",
        ":show_type_label" => $input["show_type_label"] ?? "",
        ":year"            => $input["year"] ?? "",
        ":description"     => $input["description"] ?? "",
        ":host_id"         => $input["host_id"] ?? null,
        ":participants"    => $participants,
        ":placements"      => $placements,
        ":broadcasts"      => $broadcasts,
        ":logo"            => $input["logo"] ?? "",
        ":trophy"          => $input["trophy_photo"] ?? "",
        ":house_photos"    => $house_photos,
        ":id"              => $input["id"]
    ]);

    echo json_encode([
        "status" => "success",
        "message" => "Season updated successfully"
    ]);

} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
?>
