<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);
    if(!isset($data['id']) || empty($data['name'])) {
        echo json_encode(["status"=>"error","message"=>"Incomplete data"]);
        exit;
    }

    $stmt = $conn->prepare("UPDATE languages SET name = :name WHERE id = :id");
    $stmt->execute([
        ":id" => $data['id'],
        ":name" => $data['name']
    ]);

    echo json_encode(["status"=>"success","message"=>"Language updated"]);
} 
catch(Exception $e){
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
?>
