<?php
// quick test - remove after use
require "db.php";

$userToTest = 'superadmin'; // or change to 'admin'
$plain = 'admin123';

$stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
$stmt->execute([$userToTest]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

header('Content-Type: text/plain');

if (!$user) {
    echo "USER NOT FOUND: $userToTest\n";
    exit;
}

echo "DB password_hash for {$userToTest}:\n";
echo $user['password_hash'] . "\n\n";

if (password_verify($plain, $user['password_hash'])) {
    echo "password_verify OK — server can verify the hash with plain='admin123' ✅\n";
} else {
    echo "password_verify FAILED — hash mismatch ❌\n";
}
