<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!$data) {
        echo json_encode(["status"=>"error", "message"=>"No input"]);
        exit;
    }

    $social = json_encode($data['social'] ?? []);

    $stmt = $conn->prepare("
        INSERT INTO contestants
        (name, language, show_type, season_no, photo, description, social)
        VALUES
        (:name, :language, :show_type, :season_no, :photo, :description, :social)
    ");

    $stmt->execute([
        ":name"        => $data["name"],
        ":language"    => $data["language"],
        ":show_type"   => $data["show_type"],
        ":season_no"   => $data["season_no"],
        ":photo"       => $data["photo"],
        ":description" => $data["description"],
        ":social"      => $social
    ]);

    echo json_encode(["status"=>"success", "message"=>"Contestant added"]);

} catch (Exception $e) {
    echo json_encode(["status"=>"error", "message"=>$e->getMessage()]);
}
?>
