<?php
// login.php
require __DIR__ . '/db.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$username = trim($data['username'] ?? '');
$password = $data['password'] ?? '';
$remember = !empty($data['remember']);

if(!$username || !$password){
    echo json_encode(['status'=>'error','message'=>'Missing username or password']);
    exit;
}

// allow login with username OR email
$stmt = $pdo->prepare("SELECT id, username, email, password_hash, role FROM users WHERE username = :u OR email = :u LIMIT 1");
$stmt->execute([':u' => $username]);
$user = $stmt->fetch();

if(!$user){
    echo json_encode(['status'=>'error','message'=>'Invalid username']);
    exit;
}

if(!password_verify($password, $user['password_hash'])){
    echo json_encode(['status'=>'error','message'=>'Invalid password']);
    exit;
}

// optionally check role / active flag here

// log last login
$stmt = $pdo->prepare("UPDATE users SET last_login = NOW() WHERE id = :id");
$stmt->execute([':id' => $user['id']]);

// start secure session
session_regenerate_id(true);
$_SESSION['user_id'] = $user['id'];
$_SESSION['username'] = $user['username'];
$_SESSION['role'] = $user['role'] ?? 'user';

// remember: if client requested, set a simple cookie (this is optional; better to implement token-based remember later)
if($remember){
    setcookie('bb_remember', $user['username'], time() + (30*24*3600), "/", "", false, true);
}

echo json_encode(['status'=>'success']);
exit;
?>
