<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if(!isset($data['id'])){
        echo json_encode(["status"=>"error","message"=>"ID required"]);
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM profiles WHERE id = :id");
    $stmt->execute([":id" => $data['id']]);

    echo json_encode(["status"=>"success", "message"=>"Profile deleted"]);
}
catch(Exception $e){
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
?>
