/* ===== post-load helpers: ensure theme + topbar state consistent ===== */
(function(){
  const THEME_KEY = 'bb_theme';
  const SIDEBAR_KEY = 'bb_sidebar_collapsed';

  // wait for injected global css to load, then apply theme class consistently
  function ensureThemeApplied(){
    const link = document.querySelector('link[data-global-theme]');
    const apply = () => {
      try {
        const t = localStorage.getItem(THEME_KEY) || 'dark';
        if(t === 'dark'){ document.documentElement.classList.add('dark'); document.body.classList.add('dark'); }
        else { document.documentElement.classList.remove('dark'); document.body.classList.remove('dark'); }
        // update any theme toggle button text if present
        const th = document.getElementById('ll_theme_toggle') || document.getElementById('ll_th') || document.getElementById('themeToggle') || document.getElementById('themeToggleBtn');
        if(th) th.textContent = (t === 'dark') ? '🌙' : '☀️';
      } catch(e){ console.warn('theme apply error', e); }
    };

    if(!link){
      // if CSS not injected (rare), still apply immediately
      apply();
      return;
    }
    if(link.sheet || link.complete){
      // already loaded
      apply();
    } else {
      link.addEventListener('load', apply);
      // fallback: timeout apply after 300ms
      setTimeout(apply, 350);
    }
  }

  // ensure sidebar toggle btn reflects the actual state
  function fixSidebarToggleText(){
    const sb = document.getElementById('ll_sidebar_toggle') || document.getElementById('ll_sb') || document.getElementById('sidebarToggle') || document.getElementById('sidebarToggleBtn');
    if(!sb) return;
    const isCollapsed = document.body.classList.contains('sidebar-collapsed');
    sb.textContent = isCollapsed ? '☰' : '✖';
  }

  // expose safe toggle if some pages create different buttons
  function wireControls(){
    // theme button fallback
    const th = document.getElementById('ll_theme_toggle') || document.getElementById('ll_th') || document.getElementById('themeToggle') || document.getElementById('themeToggleBtn');
    if(th && !th._wired){
      th._wired = true;
      th.addEventListener('click', () => {
        const now = document.documentElement.classList.contains('dark') ? 'light' : 'dark';
        if(now === 'dark'){ document.documentElement.classList.add('dark'); document.body.classList.add('dark'); }
        else { document.documentElement.classList.remove('dark'); document.body.classList.remove('dark'); }
        try { localStorage.setItem(THEME_KEY, now); } catch(e){}
        th.textContent = (now === 'dark') ? '🌙' : '☀️';
      });
    }

    // sidebar toggle fallback
    const sb = document.getElementById('ll_sidebar_toggle') || document.getElementById('ll_sb') || document.getElementById('sidebarToggle') || document.getElementById('sidebarToggleBtn');
    if(sb && !sb._wired){
      sb._wired = true;
      sb.addEventListener('click', () => {
        const isCollapsed = document.body.classList.toggle('sidebar-collapsed');
        try { localStorage.setItem(SIDEBAR_KEY, isCollapsed ? 'collapsed' : 'expanded'); } catch(e){}
        sb.textContent = isCollapsed ? '☰' : '✖';
      });
    }
  }

  // run after short delay (allows fragments to be inserted)
  setTimeout(() => {
    ensureThemeApplied();
    fixSidebarToggleText();
    wireControls();
  }, 120);
})();
