/***************************************************
 * languages.js — Path: /public_html/dashboard/languages.js
 ***************************************************/

const API_GET_LANG = "api/get_languages.php";
const API_SAVE_LANG = "api/save_language.php";
const API_UPDATE_LANG = "api/update_language.php";
const API_DELETE_LANG = "api/delete_language.php";

const langArea = document.getElementById('langArea');
const noLangs = document.getElementById('noLangs');
const addLangBtn = document.getElementById('addLangBtn');

const langModal = document.getElementById('langModal');
const closeLangModal = document.getElementById('closeLangModal');
const langModalTitle = document.getElementById('langModalTitle');
const l_name = document.getElementById('l_name');
const saveLangBtn = document.getElementById('saveLangBtn');

let languages = [];
let editingLangId = null;

async function fetchJSON(url, options={}) {
  const r = await fetch(url, options);
  return r.json();
}

async function loadLanguages() {
  try {
    const r = await fetchJSON(API_GET_LANG);
    languages = r.data || [];
  } catch (e) {
    languages = [];
  }
  renderLanguages();
}

function renderLanguages(){
  langArea.innerHTML = "";
  if(!languages.length){
    noLangs.style.display = "block";
    return;
  }
  noLangs.style.display = "none";

  languages.forEach(l=>{
    const card = document.createElement('div');
    card.className = "lang-card";

    card.innerHTML = `
      <div>${l.name}</div>
      <div style="display:flex;gap:8px;">
        <button class="btn btn-ghost" data-id="${l.id}" data-action="edit">Edit</button>
        <button class="btn btn-danger" data-id="${l.id}" data-action="delete">Delete</button>
      </div>
    `;
    langArea.appendChild(card);
  });

  langArea.querySelectorAll('[data-action="edit"]').forEach(btn=>{
    btn.onclick = ()=> openEditLanguage(btn.dataset.id);
  });

  langArea.querySelectorAll('[data-action="delete"]').forEach(btn=>{
    btn.onclick = ()=> deleteLanguage(btn.dataset.id);
  });
}

function openModalLang(){ langModal.classList.add("open"); }
function closeModalLang(){ langModal.classList.remove("open"); }

addLangBtn.onclick = ()=> {
  editingLangId = null;
  langModalTitle.textContent = "Add Language";
  l_name.value = "";
  openModalLang();
};

closeLangModal.onclick = closeModalLang;
langModal.onclick = (e)=>{ if(e.target === langModal) closeModalLang(); };

saveLangBtn.onclick = async ()=>{
  const name = l_name.value.trim();
  if(!name){ alert("Enter name"); return; }

  const payload = { name };

  try {
    let res;
    if(editingLangId){
      payload.id = editingLangId;
      res = await fetchJSON(API_UPDATE_LANG, {
        method:"POST",
        headers:{"Content-Type":"application/json"},
        body:JSON.stringify(payload)
      });
    } else {
      res = await fetchJSON(API_SAVE_LANG, {
        method:"POST",
        headers:{"Content-Type":"application/json"},
        body:JSON.stringify(payload)
      });
    }

    if(res.status === "success"){
      closeModalLang();
      loadLanguages();
    } else {
      alert("Error: " + (res.message || ""));
    }
  }
  catch(e){
    console.error(e);
    alert("Save failed");
  }
};

async function openEditLanguage(id){
  const l = languages.find(x=>String(x.id)===String(id));
  if(!l) return alert("Not found");

  editingLangId = id;
  langModalTitle.textContent = "Edit Language";
  l_name.value = l.name;
  openModalLang();
}

async function deleteLanguage(id){
  if(!confirm("Delete language?")) return;

  try {
    const res = await fetchJSON(API_DELETE_LANG, {
      method:"POST",
      headers:{"Content-Type":"application/json"},
      body:JSON.stringify({id})
    });

    if(res.status==="success"){
      loadLanguages();
    } else {
      alert("Delete failed: " + (res.message||""));
    }
  }
  catch(e){
    console.error(e);
    alert("Delete failed");
  }
}

/* init */
loadLanguages();
