/* =========================================================
   Dashboard Home – Count Stats + Recent Updates
   ========================================================= */

document.addEventListener("DOMContentLoaded", () => {

  loadCounts();
  loadRecentUpdates();

});

/* ---------------------------------------------------------
   Fetch & Display Counts
   --------------------------------------------------------- */
function loadCounts() {

  // Languages
  fetch("api/get_languages.php")
    .then(r => r.json())
    .then(j => {
      if (j.status === "success") {
        document.getElementById("countLanguages").textContent = j.data.length;
      }
    });

  // Hosts
  fetch("api/get_hosts.php")
    .then(r => r.json())
    .then(j => {
      if (j.status === "success") {
        document.getElementById("countHosts").textContent = j.data.length;
      }
    });

  // Contestants
  fetch("api/get_contestants.php")
    .then(r => r.json())
    .then(j => {
      if (j.status === "success") {
        document.getElementById("countContestants").textContent = j.data.length;
      }
    });

  // Seasons
  fetch("api/get_seasons.php")
    .then(r => r.json())
    .then(j => {
      if (j.status === "success") {
        document.getElementById("countSeasons").textContent = j.data.length;
      }
    });

  // Broadcasts
  fetch("api/get_broadcasts.php")
    .then(r => r.json())
    .then(j => {
      if (j.status === "success") {
        document.getElementById("countBroadcasts").textContent = j.data.length;
      }
    });

}


/* ---------------------------------------------------------
   Recent Updates
   --------------------------------------------------------- */
function loadRecentUpdates() {

  Promise.all([
    fetch("api/get_hosts.php").then(r => r.json()),
    fetch("api/get_seasons.php").then(r => r.json()),
    fetch("api/get_contestants.php").then(r => r.json())
  ])
    .then(([hosts, seasons, contestants]) => {

      let list = [];

      if (hosts.status === "success") {
        hosts.data.slice(-3).forEach(h => {
          list.push({
            type: "Host",
            name: h.name,
            time: h.created_at || "Recently"
          });
        });
      }

      if (seasons.status === "success") {
        seasons.data.slice(-3).forEach(s => {
          list.push({
            type: "Season",
            name: s.tag,
            time: s.year || "Recently"
          });
        });
      }

      if (contestants.status === "success") {
        contestants.data.slice(-3).forEach(c => {
          list.push({
            type: "Contestant",
            name: c.name,
            time: c.language || "Recently"
          });
        });
      }

      list.reverse();

      const container = document.getElementById("recentUpdates");
      container.innerHTML = "";

      if (list.length === 0) {
        container.innerHTML = `<div style="padding:10px; color:var(--text-muted);">No recent updates.</div>`;
        return;
      }

      list.forEach(item => {
        const row = document.createElement("div");
        row.style.padding = "10px 0";
        row.style.borderBottom = "1px solid var(--border-subtle)";
        row.innerHTML = `
          <div style="font-weight:700;">${item.type}: ${item.name}</div>
          <div style="font-size:13px; color:var(--text-muted);">${item.time}</div>
        `;
        container.appendChild(row);
      });

    })
    .catch(() => {
      document.getElementById("recentUpdates").innerHTML =
        `<div style="padding:10px; color:var(--danger);">Error loading updates.</div>`;
    });
}
