<?php
header("Content-Type: application/json");
include "db.php";

try {
    $data = json_decode(file_get_contents("php://input"), true);
    if(!$data || empty($data['name'])) {
        echo json_encode(["status"=>"error","message"=>"Language name required"]);
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO languages (name) VALUES (:name)");
    $stmt->execute([":name" => $data['name']]);

    echo json_encode(["status"=>"success","message"=>"Language added"]);
} 
catch(Exception $e){
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
}
?>
