<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);
    if(!$input) throw new Exception("Invalid input");

    $name = $input['name'] ?? '';
    $language = $input['language'] ?? '';
    $bio = $input['bio'] ?? '';
    $working_years = $input['working_years'] ?? '';
    $photo = $input['photo'] ?? '';

    if(!$name) throw new Exception("Name is required");

    $stmt = $conn->prepare("INSERT INTO hosts (name, language, bio, working_years, photo, created_at) VALUES (:name, :language, :bio, :working_years, :photo, NOW())");
    $stmt->execute([
        ":name" => $name,
        ":language" => $language,
        ":bio" => $bio,
        ":working_years" => $working_years,
        ":photo" => $photo
    ]);

    $id = $conn->lastInsertId();

    echo json_encode(["status"=>"success", "id"=>$id]);
    exit;

} catch(Exception $e){
    echo json_encode(["status"=>"error", "message"=>$e->getMessage()]);
    exit;
}
?>
