<?php
header("Content-Type: application/json");
include "db.php";

try {
    // Fetch seasons
    $stmt = $conn->prepare("SELECT * FROM seasons ORDER BY id DESC");
    $stmt->execute();
    $seasons = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Convert JSON fields
    foreach ($seasons as &$s) {
        $s['participants'] = json_decode($s['participants'], true) ?: [];
        $s['placements'] = json_decode($s['placements'], true) ?: [];
        $s['broadcasts'] = json_decode($s['broadcasts'], true) ?: [];
        $s['house_photos'] = json_decode($s['house_photos'], true) ?: [];
    }

    echo json_encode([
        "status" => "success",
        "data" => $seasons
    ]);
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}
?>
