<?php
header("Content-Type: application/json");
include "db.php";

try {
    $stmt = $conn->prepare("SELECT * FROM contestants ORDER BY id DESC");
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($rows as &$r) {
        $r['social'] = json_decode($r['social'], true) ?: [];
    }

    echo json_encode([
        "status" => "success",
        "data"   => $rows
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message"=> $e->getMessage()
    ]);
}
?>
