<?php
header("Content-Type: application/json");
include "db.php";

try {
    $input = json_decode(file_get_contents("php://input"), true);
    if(!$input || !isset($input['id'])) throw new Exception("Invalid input");

    $id = $input['id'];

    // optionally delete photo file from uploads here (not implemented to avoid accidental deletes)

    $stmt = $conn->prepare("DELETE FROM hosts WHERE id = :id");
    $stmt->execute([":id" => $id]);

    echo json_encode(["status"=>"success"]);
    exit;
} catch(Exception $e){
    echo json_encode(["status"=>"error","message"=>$e->getMessage()]);
    exit;
}
?>
